/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.tab.csv;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import org.apache.commons.csv.CSVFormat;

public class CsvSettings {
    private final char separatorChar;
    private final String recordSeparator;
    private final Character quoteChar;
    private final int maxFractionalDigits;

    private CsvSettings(char separatorChar, String recordSeparator, Character quoteChar, int maxFractionalDigits) {
        this.separatorChar = separatorChar;
        this.recordSeparator = recordSeparator;
        this.quoteChar = quoteChar;
        this.maxFractionalDigits = maxFractionalDigits;
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public DecimalFormat getNumberFormat() {
        char decimalSeparator = '.';
        DecimalFormat numFormat = new DecimalFormat("#.#");
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        symbols.setDecimalSeparator(decimalSeparator);
        numFormat.setDecimalFormatSymbols(symbols);
        numFormat.setMaximumFractionDigits(this.maxFractionalDigits);
        return numFormat;
    }

    public DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    CSVFormat getCsvFormat() {
        return CSVFormat.newFormat(this.separatorChar).withRecordSeparator(this.recordSeparator).withQuote(this.quoteChar);
    }

    public CsvSettings withMaxFractionalDigits(int maxFractionalDigits) {
        return new CsvSettings(this.separatorChar, this.recordSeparator, this.quoteChar, maxFractionalDigits);
    }

    public static CsvSettings dllSettings() {
        return new CsvSettings('|', "\r\n", null, 4);
    }

    public static CsvSettings stdSettings() {
        return new CsvSettings(',', "\n", Character.valueOf('\"'), 4);
    }
}

